<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'phone', 'password', 'city_id', 'birth_date', 'last_donate_date', 'blood_type_id', 'pin_code');

    public function blood_type()
    {
        return $this->belongsTo('App\Models\BloodType');
    }

    public function city()
    {
        return $this->belongsTo('App\Models\City');
    }

    public function donations()
    {
        return $this->hasMany('App\Models\Donate');
    }

    public function notifications()
    {
        return $this->belongsToMany('App\Models\Notification');
    }

    public function client_favourites()
    {
        return $this->belongsToMany('App\Models\Article');
    }

    public function client_states()
    {
        return $this->belongsToMany('App\Models\State');
    }

    public function client_blood_types()
    {
        return $this->belongsToMany('App\Models\BloodType');
    }

}